<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\UserSettingFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Users\Notable;

/**
 * Class UserSetting
 * 
 * @property int $setting_id
 * @property int $user_id
 * @property string $setting_package
 *
 * @package App\Models
 */
class UserSetting extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	
	const SETTING_ID 			= 'setting_id';
	const USER_ID 				= 'user_id';
	const SETTING_PACKAGE 		= 'setting_package';
	const TABLE_NAME 			= 'user_settings';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::SETTING_ID;
	public $timestamps 			= false;
	public $incrementing 		= true;

	protected $casts = [
		self::SETTING_ID 		=> 'int',
		self::USER_ID 			=> 'int',
		self::SETTING_PACKAGE 	=> 'array',
	];

	protected $fillable = [
		self::USER_ID,
		self::SETTING_PACKAGE
	];

	public static function factory(): UserSettingFactory
	{
		return UserSettingFactory::new();
	}
}
