<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\UserDisciplinaryFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Users\Disciplinary;

//Enums
use App\Enums\Users\DisciplinaryAction;
use App\Enums\Users\DisciplinaryStatus;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Users\Notable;

/**
 * Class UserDisciplinary
 * 
 * @property int $user_disciplinary_id
 * @property int $disciplinary_id
 * @property int $user_id
 * @property DisciplinaryStatus::class $disciplinary_status
 * @property DisciplinaryAction::class $disciplinary_action_taken
 * @property Carbon $disciplinary_date_closed
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Disciplinary $disciplinary
 *
 * @package App\Models
 */
class UserDisciplinary extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	
	const USER_DISCIPLINARY_ID 			= 'user_disciplinary_id';
	const DISCIPLINARY_ID 				= 'disciplinary_id';
	const USER_ID 						= 'user_id';
	const DISCIPLINARY_STATUS 			= 'disciplinary_status';
	const DISCIPLINARY_ACTION_TAKEN 	= 'disciplinary_action_taken';
	const DISCIPLINARY_DATE_CLOSED 		= 'disciplinary_date_closed';
	const CREATED_AT 					= 'created_at';
	const UPDATED_AT 					= 'updated_at';
	const TABLE_NAME	 				= 'user_disciplinaries';
	protected $table 					= self::TABLE_NAME;
	protected $primaryKey 				= self::USER_DISCIPLINARY_ID;
	public $incrementing 				= true;

	protected $casts = [
		self::USER_DISCIPLINARY_ID 		=> 'int',
		self::DISCIPLINARY_ID 			=> 'int',
		self::USER_ID 					=> 'int',
		self::DISCIPLINARY_STATUS 		=> DisciplinaryStatus::class,
		self::DISCIPLINARY_ACTION_TAKEN	=> DisciplinaryAction::class,
		self::DISCIPLINARY_DATE_CLOSED 	=> 'datetime',
		self::CREATED_AT 				=> 'datetime',
		self::UPDATED_AT 				=> 'datetime'
	];

	protected $fillable = [
		self::DISCIPLINARY_ID,
		self::USER_ID,
		self::DISCIPLINARY_STATUS,
		self::DISCIPLINARY_ACTION_TAKEN,
		self::DISCIPLINARY_DATE_CLOSED
	];

	/**
	 * Return the disciplinary this is using
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function disciplinary(): BelongsTo
	{
		return $this->belongsTo(Disciplinary::class, Disciplinary::DISCIPLINARY_ID);
	}

	public static function factory(): UserDisciplinaryFactory
	{
		return UserDisciplinaryFactory::new();
	}
}
