<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\UploadInformationFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Users\Upload;

//Enums
use App\Enums\Users\UploadInformationValueType;

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class UploadInformation
 * 
 * @property int $upload_information_id
 * @property int $upload_id
 * @property string $upload_value
 * @property UploadInformationValueType::class $upload_value_type
 *
 * @property Upload $upload
 *
 * @package App\Models
 */
class UploadInformation extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const UPLOAD_INFORMATION_ID 	= 'upload_information_id';
	const UPLOAD_ID 				= 'upload_id';
	const UPLOAD_VALUE 				= 'upload_value';
	const UPLOAD_VALUE_TYPE 		= 'upload_value_type';
	const TABLE_NAME 				= 'upload_informations';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::UPLOAD_INFORMATION_ID;
	public $timestamps 				= false;
	public $incrementing 			= true;

	protected $casts = [
		self::UPLOAD_INFORMATION_ID	=> 'int',
		self::UPLOAD_ID 			=> 'int',
		self::UPLOAD_VALUE_TYPE 	=> UploadInformationValueType::class
	];

	protected $fillable = [
		self::UPLOAD_ID,
		self::UPLOAD_VALUE,
		self::UPLOAD_VALUE_TYPE
	];

	protected static array $lowercase = [
		self::UPLOAD_VALUE,	
	];

	/**
	 * Returns the upload this information belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function upload(): BelongsTo
	{
		return $this->belongsTo(Upload::class, Upload::UPLOAD_ID);
	}

	public static function factory(): UploadInformationFactory
	{
		return UploadInformationFactory::new();
	}
}
