<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\UploadFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Users\UploadInformation;

//Enums
use App\Enums\Users\UploadableType;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Upload
 * 
 * @property int $upload_id
 * @property int|null $user_id
 * @property UploadableType::class $uploadable_type
 * @property int $uploadable_id
 * @property string $file_type
 * @property string $url_key
 * @property string|null $file_description
 * @property string $file_name_original
 * @property string $file_name_new
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Collection|UploadInformation[] $uploadInformation
 *
 * @package App\Models
 */
class Upload extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const UPLOAD_ID 			= 'upload_id';
	const USER_ID 				= 'user_id';
	const UPLOADABLE_TYPE 		= 'uploadable_type';
	const UPLOADABLE_ID 		= 'uploadable_id';
	const FILE_TYPE 			= 'file_type';
	const URL_KEY 				= 'url_key';
	const FILE_DESCRIPTION 		= 'file_description';
	const FILE_NAME_ORIGINAL 	= 'file_name_original';
	const FILE_NAME_NEW 		= 'file_name_new';
	const CREATED_AT 			= 'created_at';
	const UPDATED_AT 			= 'updated_at';
	const TABLE_NAME 			= 'uploads';
	const MORPH_NAME 			= 'uploadable';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::UPLOAD_ID;
	public $incrementing 		= true;

	protected $casts = [
		self::UPLOAD_ID 		=> 'int',
		self::USER_ID 			=> 'int',
		self::UPLOADABLE_TYPE 	=> UploadableType::class,
		self::UPLOADABLE_ID 	=> 'int',
		self::CREATED_AT 		=> 'datetime',
		self::UPDATED_AT 		=> 'datetime'
	];

	protected $fillable = [
		self::USER_ID,
		self::UPLOADABLE_TYPE,
		self::UPLOADABLE_ID,
		self::FILE_TYPE,
		self::URL_KEY,
		self::FILE_DESCRIPTION,
		self::FILE_NAME_ORIGINAL,
		self::FILE_NAME_NEW
	];

	protected static array $lowercase = [
		self::FILE_NAME_ORIGINAL,
		self::FILE_NAME_NEW,
		self::FILE_DESCRIPTION,
		self::FILE_TYPE,
	];

	public function uploadable()
	{
		return $this->morphTo();
	}

	public function quote()
	{
		return $this->uploadable_type === UploadableType::QUOTE
			? $this->uploadable()
			: null;
	}

	public function invoice()
	{
		return $this->uploadable_type === UploadableType::INVOICE
			? $this->uploadable()
			: null;
	}
	
	public function client()
	{
		return $this->uploadable_type === UploadableType::CLIENT
			? $this->uploadable()
			: null;
	}
	
	public function business()
	{
		return $this->uploadable_type === UploadableType::BUSINESS
			? $this->uploadable()
			: null;
	}
	
	public function businessClients()
	{
		return $this->uploadable_type === UploadableType::BUSINESS_CLIENT
			? $this->uploadable()
			: null;
	}
	
	public function user()
	{
		return $this->uploadable_type === UploadableType::USER
			? $this->uploadable()
			: null;
	}
	
	public function official()
	{
		return $this->uploadable_type === UploadableType::OFFICIAL
			? $this->uploadable()
			: null;
	}
	
	public function department()
	{
		return $this->uploadable_type === UploadableType::DEPARTMNET
			? $this->uploadable()
			: null;
	}
	
	public function liquorAuthority()
	{
		return $this->uploadable_type === UploadableType::LIQUOR_AUTHORITY
			? $this->uploadable()
			: null;
	}
	
	public function franchise()
	{
		return $this->uploadable_type === UploadableType::FRANCHISE
			? $this->uploadable()
			: null;
	}
	
	public function businessItem()
	{
		return $this->uploadable_type === UploadableType::BUSINESS_ITEM
			? $this->uploadable()
			: null;
	}
	
	public function province()
	{
		return $this->uploadable_type === UploadableType::PROVINCE
			? $this->uploadable()
			: null;
	}
	
	public function item()
	{
		return $this->uploadable_type === UploadableType::ITEM
			? $this->uploadable()
			: null;
	}
	
	public function itemExpense()
	{
		return $this->uploadable_type === UploadableType::ITEM_EXPENSE
			? $this->uploadable()
			: null;
	}

	/**
	 * Returns the information attached to this upload
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function uploadInformation(): HasMany
	{
		return $this->hasMany(UploadInformation::class, self::UPLOAD_ID);
	}

	public static function factory(): UploadFactory
	{
		return UploadFactory::new();
	}
}
