<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\TemporaryAccessFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models
use App\Models\Users\Official;

//Enums
use App\Enums\Users\TemporaryAccessType;

//Traits
use App\Traits\Users\Notable;

/**
 * Class TemporaryAccess
 * 
 * @property string $access_id
 * @property TemporaryAccessType::class $accessible_type
 * @property int $accessible_id
 * @property string $temporary_password
 * @property string $temporary_password_hashed
 * @property bool $was_accessed
 * @property Carbon $temporary_access_start_time
 * @property Carbon $temporary_access_end_time
 * 
 * @property Official $official
 *
 * @package App\Models
 */
class TemporaryAccess extends Model
{
	use Notable;
	use HasFactory;
	
	const ACCESS_ID 						= 'access_id';
	const ACCESSIBLE_TYPE 					= 'accessible_type';
	const ACCESSIBLE_ID 					= 'accessible_id';
	const TEMPORARY_PASSWORD 				= 'temporary_password';
	const TEMPORARY_PASSWORD_HASHED 		= 'temporary_password_hashed';
	const WAS_ACCESSED 						= 'was_accessed';
	const TEMPORARY_ACCESS_START_TIME 		= 'temporary_access_start_time';
	const TEMPORARY_ACCESS_END_TIME 		= 'temporary_access_end_time';
	const TABLE_NAME 						= 'temporary_accesses';
	const MORPH_NAME 						= 'accessible';
	protected $table 						= self::TABLE_NAME;
	protected $primaryKey 					= self::ACCESS_ID;
	public $incrementing 					= true;
	public $timestamps 						= false;

	protected $casts = [
		self::ACCESSIBLE_TYPE 				=> TemporaryAccessType::class,
		self::ACCESSIBLE_ID 				=> 'int',
		self::WAS_ACCESSED 					=> 'bool',
		self::TEMPORARY_ACCESS_START_TIME 	=> 'datetime',
		self::TEMPORARY_ACCESS_END_TIME 	=> 'datetime'
	];

	protected $hidden = [
		self::TEMPORARY_PASSWORD,
	];

	protected $fillable = [
		self::ACCESSIBLE_TYPE,
		self::ACCESSIBLE_ID,
		self::TEMPORARY_PASSWORD,
		self::TEMPORARY_PASSWORD_HASHED,
		self::WAS_ACCESSED,
		self::TEMPORARY_ACCESS_START_TIME,
		self::TEMPORARY_ACCESS_END_TIME
	];

	protected $attributes = [
		self::WAS_ACCESSED					=> false,
	];


	/**
	 * Adds accessible relationship
	 * @return \Illuminate\Database\Eloquent\Relations\MorphTo
	 */
	public function accessible()
	{
		return $this->morphTo();
	}

	/**
	 * Return the official that this temporary access is for
	 * @return \Illuminate\Database\Eloquent\Relations\MorphTo|null
	 */
	public function official() {
		return $this->accessible_type === Official::class
			? $this->accessible()
			: null;
	}

	public static function factory(): TemporaryAccessFactory
	{
		return TemporaryAccessFactory::new();
	}
}
