<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\OfficialableFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Users\Official;
use App\Models\Locations\Department;
use App\Models\Locations\Municipality;
use App\Models\Locations\LiquorAuthority;

//Enums
use App\Enums\Users\OfficialType;

//Traits
use App\Traits\Users\Notable;

/**
 * Class Officialable
 * 
 * @property int $entity_official_id
 * @property int $official_id
 * @property OfficialType::class $officialable_type
 * @property int $officialable_id
 * 
 * @property Official $official
 * @property Department $department
 * @property Municipality $municipality
 * @property LiquorAuthority $liquorAuthority
 *
 * @package App\Models
 */
class Officialable extends Model
{
	use Notable;
	use HasFactory;
	
	const ENTITY_OFFICIAL_ID 		= 'entity_official_id';
	const OFFICIAL_ID 				= 'official_id';
	const OFFICIALABLE_TYPE 		= 'officialable_type';
	const OFFICIALABLE_ID 			= 'officialable_id';
	const TABLE_NAME 				= 'officialables';
	const MORPH_NAME 				= 'officialable';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::ENTITY_OFFICIAL_ID;
	public $timestamps 				= false;
	public $incrementing 			= true;

	protected $casts = [
		self::ENTITY_OFFICIAL_ID 	=> 'int',
		self::OFFICIAL_ID 			=> 'int',
		self::OFFICIALABLE_TYPE 	=> OfficialType::class,
		self::OFFICIALABLE_ID 		=> 'int'
	];

	protected $fillable = [
		self::OFFICIAL_ID,
		self::OFFICIALABLE_TYPE,
		self::OFFICIALABLE_ID
	];

	public function officialable()
	{
		return $this->morphTo();
	}

	/**
	 * Returns the official this officialable belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function official(): BelongsTo
	{
		return $this->belongsTo(Official::class, Official::OFFICIAL_ID);
	}

	/**
	 * Returns the department this officialable belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\MorphTo|null
	 */
	public function department()
	{
		return $this->officialable_type === Department::class
			? $this->officialable()
			: null;
	}

	/**
	 * Returns the liquor authority this officialable belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\MorphTo|null
	 */
	public function liquorAuthority()
	{
		return $this->officialable_type === LiquorAuthority::class
			? $this->officialable()
			: null;
	}

	/**
	 * Returns the municipality this officialable belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\MorphTo|null
	 */
	public function municipality()
	{
		return $this->officialable_type === Municipality::class
			? $this->officialable()
			: null;
	}

	public static function factory(): OfficialableFactory
	{
		return OfficialableFactory::new();
	}
}
