<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\NoteFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models
use App\Models\Businesses\Business;
use App\Models\Businesses\BusinessClient;
use App\Models\Items\BusinessItem;
use App\Models\Items\BusinessItemExtraField;
use App\Models\Contacts\Address;
use App\Models\Contacts\Addressable;
use App\Models\Contacts\AddressExtraField;
use App\Models\Contacts\Contact;
use App\Models\Contacts\ContactMethod;
use App\Models\Contacts\Lead;
use App\Models\Contacts\Prospect;
use App\Models\Locations\ProvinceService;
use App\Models\Locations\Province;
use App\Models\Locations\District;
use App\Models\Locations\Municipality;
use App\Models\Locations\LiquorAuthority;
use App\Models\Locations\Franchise;
use App\Models\Locations\Department;
use App\Models\Locations\DepartmentType;
use App\Models\Finances\Payment;
use App\Models\Finances\PaymentMethod;
use App\Models\Finances\Expense;
use App\Models\Finances\Creditor;
use App\Models\Finances\ExpenseCategory;
use App\Models\Finances\ExpenseBankCategory;
use App\Models\Finances\BankAccount;
use App\Models\Finances\Bank;
use App\Models\Items\Item;
use App\Models\Items\ProvinceItem;
use App\Models\Items\ItemExpense;
use App\Models\Items\ItemStep;
use App\Models\Items\Step;
use App\Models\Items\Category;
use App\Models\Quotes\Quote;
use App\Models\Quotes\QuoteItem;
use App\Models\Quotes\QuoteItemExpense;
use App\Models\Invoices\Invoice;
use App\Models\Invoices\InvoiceItem;
use App\Models\Invoices\InvoiceItemExpense;
use App\Models\Users\Client;
use App\Models\Users\Upload;
use App\Models\Users\UploadInformation;
use App\Models\Users\TemporaryAccess;
use App\Models\Users\Official;
use App\Models\Users\Officialable;
use App\Models\Users\FranchiseUser;
use App\Models\Users\User;
use App\Models\Users\UserSetting;
use App\Models\Users\GlobalSetting;
use App\Models\Users\ChangeRequest;
use App\Models\Users\UserDisciplinary;
use App\Models\Users\EmailTemplate;
use App\Models\Users\Disciplinary;
use App\Models\Users\Attendance;
use App\Models\Users\Clocking;
use App\Models\Users\LeaveRequest;

//Enums
use App\Enums\Users\NotableType;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Core\LowercaseAttributes;

/**
 * Class Note
 * 
 * @property int $note_id
 * @property int|null $user_id
 * @property NotableType::class $notable_type
 * @property int $notable_id
 * @property string $note_title
 * @property string $note_text
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @property \Illuminate\Database\Eloquent\Model $notable
 * @property Business|null $business
 * @property BusinessClient|null $businessClients
 * @property BusinessItem|null $businessItem
 * @property BusinessItemExtraField|null $businessItemExtraField
 * @property Address|null $address
 * @property Addressable|null $addressable
 * @property AddressExtraField|null $addressExtraField
 * @property Contact|null $contact
 * @property ContactMethod|null $contactMethod
 * @property Lead|null $lead
 * @property Prospect|null $prospect
 * @property ProvinceService|null $provinceService
 * @property Province|null $province
 * @property District|null $district
 * @property Municipality|null $municipality
 * @property LiquorAuthority|null $liquorAuthority
 * @property Franchise|null $franchise
 * @property Department|null $department
 * @property DepartmentType|null $departmentType
 * @property Payment|null $payment
 * @property PaymentMethod|null $paymentMethod
 * @property Expense|null $expense
 * @property Creditor|null $creditor
 * @property ExpenseCategory|null $expenseCategory
 * @property ExpenseBankCategory|null $expenseBankCategory
 * @property BankAccount|null $bankAccount
 * @property Bank|null $bank
 * @property Item|null $item
 * @property ProvinceItem|null $provinceItem
 * @property ItemExpense|null $itemExpense
 * @property ItemStep|null $itemStep
 * @property Step|null $step
 * @property Category|null $category
 * @property Quote|null $quote
 * @property QuoteItem|null $quoteItem
 * @property QuoteItemExpense|null $quoteItemExpense
 * @property Invoice|null $invoice
 * @property InvoiceItem|null $invoiceItem
 * @property InvoiceItemExpense|null $invoiceItemExpense
 * @property Client|null $client
 * @property Upload|null $upload
 * @property UploadInformation|null $uploadInformation
 * @property TemporaryAccess|null $temporaryAccess
 * @property Official|null $official
 * @property Officialable|null $officialable
 * @property FranchiseUser|null $franchiseUser
 * @property User|null $user
 * @property UserSetting|null $userSetting
 * @property GlobalSetting|null $globalSetting
 * @property ChangeRequest|null $changeRequest
 * @property UserDisciplinary|null $userDisciplinary
 * @property EmailTemplate|null $emailTemplate
 * @property Disciplinary|null $disciplinary
 * @property Attendance|null $attendance
 * @property Clocking|null $clocking
 * @property LeaveRequest|null $leav
 * @package App\Models
 */
class Note extends Model
{
	use BelongsToUser;
	use HasFactory;
	use LowercaseAttributes;

	const NOTE_ID 			= 'note_id';
	const USER_ID 			= 'user_id';
	const NOTABLE_TYPE 		= 'notable_type';
	const NOTABLE_ID 		= 'notable_id';
	const NOTE_TITLE 		= 'note_title';
	const NOTE_TEXT 		= 'note_text';
	const CREATED_AT 		= 'created_at';
	const UPDATED_AT 		= 'updated_at';
	const TABLE_NAME 		= 'notes';
	const MORPH_NAME 		= 'notable';
	protected $table 		= self::TABLE_NAME;
	protected $primaryKey 	= self::NOTE_ID;
	public $incrementing 	= true;

	protected $casts = [
		self::NOTE_ID		=> 'int',
		self::USER_ID 		=> 'int',
		self::NOTABLE_TYPE 	=> NotableType::class,
		self::NOTABLE_ID 	=> 'int',
		self::CREATED_AT 	=> 'datetime',
		self::UPDATED_AT 	=> 'datetime'
	];

	protected $fillable = [
		self::USER_ID,
		self::NOTABLE_TYPE,
		self::NOTABLE_ID,
		self::NOTE_TITLE,
		self::NOTE_TEXT
	];

	protected static array $lowercase = [
		self::NOTE_TITLE,
		self::NOTE_TEXT,	
	];

	/**
	 * NOTE : All relationships here are for all models
	 * - If a new model is added, we need to add the relationship
	 */

	public function notable()
	{
		return $this->morphTo();
	}

	public function business()
	{
		return $this->notable_type === Business::class
			? $this->notable()
			: null;
	}
	
	public function businessClients()
	{
		return $this->notable_type === BusinessClient::class
			? $this->notable()
			: null;
	}
	
	public function businessItem()
	{
		return $this->notable_type === BusinessItem::class
			? $this->notable()
			: null;
	}
	
	public function businessItemExtraField()
	{
		return $this->notable_type === BusinessItemExtraField::class
			? $this->notable()
			: null;
	}
	
	public function address()
	{
		return $this->notable_type === Address::class
			? $this->notable()
			: null;
	}
	
	public function addressable()
	{
		return $this->notable_type === Addressable::class
			? $this->notable()
			: null;
	}
	
	public function addressExtraField()
	{
		return $this->notable_type === AddressExtraField::class
			? $this->notable()
			: null;
	}
	
	public function contact()
	{
		return $this->notable_type === Contact::class
			? $this->notable()
			: null;
	}
	
	public function contactMethod()
	{
		return $this->notable_type === ContactMethod::class
			? $this->notable()
			: null;
	}
	
	public function lead()
	{
		return $this->notable_type === Lead::class
			? $this->notable()
			: null;
	}
	
	public function prospect()
	{
		return $this->notable_type === Prospect::class
			? $this->notable()
			: null;
	}
	
	public function provinceService()
	{
		return $this->notable_type === ProvinceService::class
			? $this->notable()
			: null;
	}
	
	public function province()
	{
		return $this->notable_type === Province::class
			? $this->notable()
			: null;
	}
	
	public function district()
	{
		return $this->notable_type === District::class
			? $this->notable()
			: null;
	}
	
	public function municipality()
	{
		return $this->notable_type === Municipality::class
			? $this->notable()
			: null;
	}
	
	public function liquorAuthority()
	{
		return $this->notable_type === LiquorAuthority::class
			? $this->notable()
			: null;
	}
	
	public function franchise()
	{
		return $this->notable_type === Franchise::class
			? $this->notable()
			: null;
	}
	
	public function department()
	{
		return $this->notable_type === Department::class
			? $this->notable()
			: null;
	}
	
	public function departmentType()
	{
		return $this->notable_type === DepartmentType::class
			? $this->notable()
			: null;
	}
	
	public function payment()
	{
		return $this->notable_type === Payment::class
			? $this->notable()
			: null;
	}
	
	public function paymentMethod()
	{
		return $this->notable_type === PaymentMethod::class
			? $this->notable()
			: null;
	}
	
	public function expense()
	{
		return $this->notable_type === Expense::class
			? $this->notable()
			: null;
	}
	
	public function creditor()
	{
		return $this->notable_type === Creditor::class
			? $this->notable()
			: null;
	}
	
	public function expenseCategory()
	{
		return $this->notable_type === ExpenseCategory::class
			? $this->notable()
			: null;
	}
	
	public function expenseBankCategory()
	{
		return $this->notable_type === ExpenseBankCategory::class
			? $this->notable()
			: null;
	}
	
	public function bankAccount()
	{
		return $this->notable_type === BankAccount::class
			? $this->notable()
			: null;
	}
	
	public function bank()
	{
		return $this->notable_type === Bank::class
			? $this->notable()
			: null;
	}
	
	public function item()
	{
		return $this->notable_type === Item::class
			? $this->notable()
			: null;
	}
	
	public function provinceItem()
	{
		return $this->notable_type === ProvinceItem::class
			? $this->notable()
			: null;
	}
	
	public function itemExpense()
	{
		return $this->notable_type === ItemExpense::class
			? $this->notable()
			: null;
	}
	
	public function itemStep()
	{
		return $this->notable_type === ItemStep::class
			? $this->notable()
			: null;
	}
	
	public function step()
	{
		return $this->notable_type === Step::class
			? $this->notable()
			: null;
	}
	
	public function category()
	{
		return $this->notable_type === Category::class
			? $this->notable()
			: null;
	}
	
	public function quote()
	{
		return $this->notable_type === Quote::class
			? $this->notable()
			: null;
	}
	
	public function quoteItem()
	{
		return $this->notable_type === QuoteItem::class
			? $this->notable()
			: null;
	}
	
	public function quoteItemExpense()
	{
		return $this->notable_type === QuoteItemExpense::class
			? $this->notable()
			: null;
	}
	
	public function invoice()
	{
		return $this->notable_type === Invoice::class
			? $this->notable()
			: null;
	}
	
	public function invoiceItem()
	{
		return $this->notable_type === InvoiceItem::class
			? $this->notable()
			: null;
	}
	
	public function invoiceItemExpense()
	{
		return $this->notable_type === InvoiceItemExpense::class
			? $this->notable()
			: null;
	}
	
	public function client()
	{
		return $this->notable_type === Client::class
			? $this->notable()
			: null;
	}
	
	public function upload()
	{
		return $this->notable_type === Upload::class
			? $this->notable()
			: null;
	}
	
	public function uploadInformation()
	{
		return $this->notable_type === UploadInformation::class
			? $this->notable()
			: null;
	}
	
	public function temporaryAccess()
	{
		return $this->notable_type === TemporaryAccess::class
			? $this->notable()
			: null;
	}
	
	public function official()
	{
		return $this->notable_type === Official::class
			? $this->notable()
			: null;
	}
	
	public function officialable()
	{
		return $this->notable_type === Officialable::class
			? $this->notable()
			: null;
	}
	
	public function franchiseUser()
	{
		return $this->notable_type === FranchiseUser::class
			? $this->notable()
			: null;
	}
	
	public function user()
	{
		return $this->notable_type === User::class
			? $this->notable()
			: null;
	}
	
	public function userSetting()
	{
		return $this->notable_type === UserSetting::class
			? $this->notable()
			: null;
	}
	
	public function globalSetting()
	{
		return $this->notable_type === GlobalSetting::class
			? $this->notable()
			: null;
	}
	
	public function changeRequest()
	{
		return $this->notable_type === ChangeRequest::class
			? $this->notable()
			: null;
	}
	
	public function userDisciplinary()
	{
		return $this->notable_type === UserDisciplinary::class
			? $this->notable()
			: null;
	}
	
	public function emailTemplate()
	{
		return $this->notable_type === EmailTemplate::class
			? $this->notable()
			: null;
	}
	
	public function disciplinary()
	{
		return $this->notable_type === Disciplinary::class
			? $this->notable()
			: null;
	}
	
	public function attendance()
	{
		return $this->notable_type === Attendance::class
			? $this->notable()
			: null;
	}
	
	public function clocking()
	{
		return $this->notable_type === Clocking::class
			? $this->notable()
			: null;
	}
	
	public function leaveRequest()
	{
		return $this->notable_type === LeaveRequest::class
			? $this->notable()
			: null;
	}
	
	public static function factory(): NoteFactory
	{
		return NoteFactory::new(); 
	}
}
