<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\LeaveRequestFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Users\User;

//Enums
use App\Enums\Users\LeaveRequestStatus;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class LeaveRequest
 * 
 * @property int $leave_request_id
 * @property int $user_id
 * @property int|null $approval_user_id
 * @property Carbon $leave_date_from
 * @property Carbon $leave_date_to
 * @property string|null $leave_reason
 * @property LeaveRequestStatus::class $leave_status
 * @property string|null $leave_message
 * 
 * @property User $approver
 *
 * @package App\Models
 */
class LeaveRequest extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const LEAVE_REQUEST_ID 		= 'leave_request_id';
	const USER_ID 				= 'user_id';
	const APPROVAL_USER_ID 		= 'approval_user_id';
	const LEAVE_DATE_FROM 		= 'leave_date_from';
	const LEAVE_DATE_TO 		= 'leave_date_to';
	const LEAVE_REASON 			= 'leave_reason';
	const LEAVE_STATUS 			= 'leave_status';
	const LEAVE_MESSAGE 		= 'leave_message';
	const TABLE_NAME 			= 'leave_requests';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::LEAVE_REQUEST_ID;
	public $timestamps 			= false;
	public $incrementing 		= true;

	protected $casts = [
		self::LEAVE_REQUEST_ID 	=> 'int',
		self::USER_ID 			=> 'int',
		self::APPROVAL_USER_ID 	=> 'int',
		self::LEAVE_DATE_FROM 	=> 'datetime',
		self::LEAVE_DATE_TO 	=> 'datetime',
		self::LEAVE_STATUS 		=> LeaveRequestStatus::class
	];

	protected $fillable = [
		self::USER_ID,
		self::APPROVAL_USER_ID,
		self::LEAVE_DATE_FROM,
		self::LEAVE_DATE_TO,
		self::LEAVE_REASON,
		self::LEAVE_STATUS,
		self::LEAVE_MESSAGE
	];

	protected static array $lowercase = [
		self::LEAVE_REASON,
		self::LEAVE_MESSAGE,
	];

	/**
	 * Returns the user that needs to make the approval on this leave request
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function approver() {
		return $this->belongsTo(User::class, self::APPROVAL_USER_ID, User::USER_ID);
	}

	public static function factory(): LeaveRequestFactory
	{
		return LeaveRequestFactory::new();
	}
}
