<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\GlobalSettingFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums

//Traits
use App\Traits\Users\Notable;

/**
 * Class GlobalSetting
 * 
 * @property int $setting_id
 * @property string $setting_name
 * @property string $setting_value
 *
 * @package App\Models
 */
class GlobalSetting extends Model
{
	use Notable;
	use HasFactory;
	
	const SETTING_ID 		= 'setting_id';
	const SETTING_NAME 		= 'setting_name';
	const SETTING_VALUE 	= 'setting_value';
	const TABLE_NAME 		= 'global_settings';
	protected $table	 	= self::TABLE_NAME;
	protected $primaryKey 	= self::SETTING_ID;
	public $incrementing 	= true;
	public $timestamps 		= false;

	protected $casts = [
		self::SETTING_ID 	=> 'int'
	];

	protected $fillable = [
		self::SETTING_NAME,
		self::SETTING_VALUE
	];

	public static function factory(): GlobalSettingFactory
	{
		return GlobalSettingFactory::new();
	}
}
