<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\FranchiseUserFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums
use App\Enums\Users\FranchiseUserRole;

//Traits
use App\Traits\Locations\BelongsToFranchise;
use App\Traits\Users\BelongsToUser;
use App\Traits\Users\Notable;

/**
 * Class FranchiseUser
 * 
 * @property int $franchise_user_id
 * @property int $franchise_id
 * @property int $user_id
 * @property FranchiseUserRole::class $franchise_user_role
 *
 * @package App\Models
 */
class FranchiseUser extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	use BelongsToFranchise;
	
	const FRANCHISE_USER_ID 		= 'franchise_user_id';
	const FRANCHISE_ID 				= 'franchise_id';
	const USER_ID 					= 'user_id';
	const FRANCHISE_USER_ROLE 		= 'franchise_user_role';
	const TABLE_NAME 				= 'franchise_users';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::FRANCHISE_USER_ID;
	public $incrementing 			= true;
	public $timestamps 				= false;

	protected $casts = [
		self::FRANCHISE_USER_ID 	=> 'int',
		self::FRANCHISE_ID 			=> 'int',
		self::USER_ID 				=> 'int',
		self::FRANCHISE_USER_ROLE 	=> FranchiseUserRole::class
	];

	protected $fillable = [
		self::FRANCHISE_ID,
		self::USER_ID,
		self::FRANCHISE_USER_ROLE
	];

	public static function factory(): FranchiseUserFactory
	{
		return FranchiseUserFactory::new();
	}
}
