<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\EmailTemplateFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums
use App\Enums\Users\EmailTemplateType;

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class EmailTemplate
 * 
 * @property int $email_template_id
 * @property string $email_template_title
 * @property EmailTemplateType::class $email_template_type
 * @property string $email_template_body
 * @property string|null $email_template_subject
 * @property string|null $email_template_from_name
 * @property string|null $email_template_from_email
 * @property string|null $email_template_cc
 * @property string|null $email_template_bcc
 *
 * @package App\Models
 */
class EmailTemplate extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const EMAIL_TEMPLATE_ID 			= 'email_template_id';
	const EMAIL_TEMPLATE_TITLE 			= 'email_template_title';
	const EMAIL_TEMPLATE_TYPE 			= 'email_template_type';
	const EMAIL_TEMPLATE_BODY 			= 'email_template_body';
	const EMAIL_TEMPLATE_SUBJECT 		= 'email_template_subject';
	const EMAIL_TEMPLATE_FROM_NAME 		= 'email_template_from_name';
	const EMAIL_TEMPLATE_FROM_EMAIL 	= 'email_template_from_email';
	const EMAIL_TEMPLATE_CC 			= 'email_template_cc';
	const EMAIL_TEMPLATE_BCC 			= 'email_template_bcc';
	const TABLE_NAME 					= 'email_templates';
	protected $table 					= self::TABLE_NAME;
	protected $primaryKey 				= self::EMAIL_TEMPLATE_ID;
	public $timestamps 					= false;
	public $incrementing 				= true;

	protected $casts = [
		self::EMAIL_TEMPLATE_ID 		=> 'int',
		self::EMAIL_TEMPLATE_TYPE 		=> EmailTemplateType::class
	];

	protected $fillable = [
		self::EMAIL_TEMPLATE_TITLE,
		self::EMAIL_TEMPLATE_TYPE,
		self::EMAIL_TEMPLATE_BODY,
		self::EMAIL_TEMPLATE_SUBJECT,
		self::EMAIL_TEMPLATE_FROM_NAME,
		self::EMAIL_TEMPLATE_FROM_EMAIL,
		self::EMAIL_TEMPLATE_CC,
		self::EMAIL_TEMPLATE_BCC
	];

	protected static array $lowercase = [
		self::EMAIL_TEMPLATE_TITLE,
		self::EMAIL_TEMPLATE_SUBJECT,
		self::EMAIL_TEMPLATE_FROM_NAME,
		self::EMAIL_TEMPLATE_CC,
		self::EMAIL_TEMPLATE_BCC,
		self::EMAIL_TEMPLATE_FROM_EMAIL	
	];

	public static function factory(): EmailTemplateFactory
	{
		return EmailTemplateFactory::new();
	}
}
