<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Database\Factories\Users\DisciplinaryFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Users\UserDisciplinary;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Disciplinary
 * 
 * @property int $disciplinary_id
 * @property string $disciplinary_type
 * @property string $disciplinaries_reason
 * 
 * @property Collection|UserDisciplinary[] $userDisciplinaries
 *
 * @package App\Models
 */
class Disciplinary extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const DISCIPLINARY_ID 			= 'disciplinary_id';
	const DISCIPLINARY_TYPE 		= 'disciplinary_type';
	const DISCIPLINARIES_REASON 	= 'disciplinaries_reason';
	const TABLE_NAME 				= 'disciplinaries';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::DISCIPLINARY_ID;
	public $incrementing 			= true;
	public $timestamps 				= false;

	protected $casts = [
		self::DISCIPLINARY_ID 		=> 'int'
	];

	protected $fillable = [
		self::DISCIPLINARY_TYPE,
		self::DISCIPLINARIES_REASON
	];

	protected static array $lowercase = [
		self::DISCIPLINARY_TYPE,
		self::DISCIPLINARIES_REASON,
	];

	/**
	 * Return the user discplinaries that have received this disciplinary
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function userDisciplinaries(): HasMany
	{
		return $this->hasMany(UserDisciplinary::class, self::DISCIPLINARY_ID);
	}

	public static function factory(): DisciplinaryFactory
	{
		return DisciplinaryFactory::new();
	}
}
