<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\ClockingFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models

//Enums

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Users\Notable;

/**
 * Class Clocking
 * 
 * @property int $clocking_id
 * @property int $user_id
 * @property Carbon $clock_in_datetime
 * @property Carbon|null $clock_out_datetime
 * 
 *
 * @package App\Models
 */
class Clocking extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;

	const CLOCKING_ID 				= 'clocking_id';
	const USER_ID 					= 'user_id';
	const CLOCK_IN_DATETIME 		= 'clock_in_datetime';
	const CLOCK_OUT_DATETIME 		= 'clock_out_datetime';
	const TABLE_NAME 				= 'clockings';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::CLOCKING_ID;
	public $timestamps 				= false;
	public $incrementing 			= true;

	protected $casts = [
		self::CLOCKING_ID 			=> 'int',
		self::USER_ID 				=> 'int',
		self::CLOCK_IN_DATETIME 	=> 'datetime',
		self::CLOCK_OUT_DATETIME 	=> 'datetime'
	];

	protected $fillable = [
		self::USER_ID,
		self::CLOCK_IN_DATETIME,
		self::CLOCK_OUT_DATETIME
	];

	public static function factory(): ClockingFactory
	{
		return ClockingFactory::new();
	}
}
