<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use App\Observers\Users\ClientObserver;
use Carbon\Carbon;
use Database\Factories\Users\ClientFactory;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

//Models
use App\Models\Businesses\Business;
use App\Models\Businesses\BusinessClient;

//Enums

//Traits
use App\Traits\Contacts\BelongsToContact;
use App\Traits\Users\Changable;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;
use App\Traits\Users\Uploadable;

/**
 * Class Client
 * 
 * @property int $client_id
 * @property int $contact_id
 * @property string $username
 * @property string $password
 * @property bool $client_can_access
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Collection|Business[] $businesses
 *
 * @package App\Models
 */

#[ObservedBy(ClientObserver::class)]
class Client extends Model
{
	use BelongsToContact;
	use Changable;
	use Uploadable;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const CLIENT_ID 			= 'client_id';
	const CONTACT_ID 			= 'contact_id';
	const USERNAME 				= 'username';
	const PASSWORD 				= 'password';
	const CLIENT_CAN_ACCESS 	= 'client_can_access';
	const CREATED_AT 			= 'created_at';
	const UPDATED_AT 			= 'updated_at';
	const TABLE_NAME 			= 'clients';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::CLIENT_ID;
	public $incrementing 		= true;

	protected $casts = [
		self::CLIENT_ID 		=> 'int',
		self::CONTACT_ID 		=> 'int',
		self::CLIENT_CAN_ACCESS => 'bool',
		self::CREATED_AT 		=> 'datetime',
		self::UPDATED_AT 		=> 'datetime'
	];

	protected $hidden = [
		self::PASSWORD
	];

	protected $fillable = [
		self::CONTACT_ID,
		self::USERNAME,
		self::PASSWORD,
		self::CLIENT_CAN_ACCESS
	];

	protected $attributes = [
		self::CLIENT_CAN_ACCESS		=> true,
	];

	protected static array $lowercase = [
		self::USERNAME,
	];

	/**
	 * Returns the businesses this client is associated with
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
	 */
	public function businesses(): BelongsToMany
	{
		return $this->belongsToMany(Business::class, 
									BusinessClient::TABLE_NAME, 
									self::CLIENT_ID, 
									Business::BUSINESS_ID)
					->withPivot(BusinessClient::BUSINESS_CLIENT_ID, BusinessClient::CLIENT_ROLE, BusinessClient::IS_PRIMARY);
	}

	public static function factory(): ClientFactory
	{
		return ClientFactory::new();
	}
}
