<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Users;

use Carbon\Carbon;
use Database\Factories\Users\AttendanceFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models
use App\Models\Users\User;

//Enums
use App\Enums\Users\AttendanceStatus;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Users\Notable;

/**
 * Class Attendance
 * 
 * @property int $attendance_id
 * @property int $user_id
 * @property Carbon|null $attendance_in_datetime
 * @property Carbon|null $attendance_out_datetime
 * @property AttendanceStatus::class $attendance_status
 * 
 * @property User $user
 *
 * @package App\Models
 */
class Attendance extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;

	const ATTENDANCE_ID 				= 'attendance_id';
	const USER_ID 						= 'user_id';
	const ATTENDANCE_IN_DATETIME 		= 'attendance_in_datetime';
	const ATTENDANCE_OUT_DATETIME 		= 'attendance_out_datetime';
	const ATTENDANCE_STATUS 			= 'attendance_status';
	const TABLE_NAME 					= 'attendances';
	protected $table 					= self::TABLE_NAME;
	protected $primaryKey 				= self::ATTENDANCE_ID;
	public $incrementing 				= true;
	public $timestamps 					= false;

	protected $casts = [
		self::ATTENDANCE_ID 			=> 'int',
		self::USER_ID 					=> 'int',
		self::ATTENDANCE_IN_DATETIME 	=> 'datetime',
		self::ATTENDANCE_OUT_DATETIME 	=> 'datetime',
		self::ATTENDANCE_STATUS 		=> AttendanceStatus::class
	];

	protected $fillable = [
		self::USER_ID,
		self::ATTENDANCE_IN_DATETIME,
		self::ATTENDANCE_OUT_DATETIME,
		self::ATTENDANCE_STATUS
	];

	public static function factory(): AttendanceFactory
	{
		return AttendanceFactory::new();
	}
}
