<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Quotes;

use Database\Factories\Quotes\QuoteItemExpenseFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Quotes\QuoteItem;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class QuoteItemExpense
 * 
 * @property int $quote_item_expense_id
 * @property int $quote_item_id
 * @property string $quote_item_expense_name
 * @property string $quote_item_expense_description
 * @property float $quote_item_expense_price
 * 
 * @property QuoteItem $quoteItem
 *
 * @package App\Models
 */

class QuoteItemExpense extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const QUOTE_ITEM_EXPENSE_ID 			= 'quote_item_expense_id';
	const QUOTE_ITEM_ID 					= 'quote_item_id';
	const QUOTE_ITEM_EXPENSE_NAME 			= 'quote_item_expense_name';
	const QUOTE_ITEM_EXPENSE_DESCRIPTION	= 'quote_item_expense_description';
	const QUOTE_ITEM_EXPENSE_PRICE 			= 'quote_item_expense_price';
	const TABLE_NAME 						= 'quote_item_expenses';
	protected $table 						= self::TABLE_NAME;
	protected $primaryKey 					= self::QUOTE_ITEM_EXPENSE_ID;
	public $timestamps 						= false;
	public $incrementing 					= true;

	protected $casts = [
		self::QUOTE_ITEM_EXPENSE_ID 		=> 'int',
		self::QUOTE_ITEM_ID 				=> 'int',
		self::QUOTE_ITEM_EXPENSE_PRICE 		=> 'float'
	];

	protected $fillable = [
		self::QUOTE_ITEM_ID,
		self::QUOTE_ITEM_EXPENSE_NAME,
		self::QUOTE_ITEM_EXPENSE_DESCRIPTION,
		self::QUOTE_ITEM_EXPENSE_PRICE
	];

	protected static array $lowercase = [
		self::QUOTE_ITEM_EXPENSE_NAME,
		self::QUOTE_ITEM_EXPENSE_DESCRIPTION,	
	];

	/**
	 * Return the quoteItem this expense belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function quoteItem(): BelongsTo
	{
		return $this->belongsTo(QuoteItem::class, QuoteItem::QUOTE_ITEM_ID);
	}

	public static function factory(): QuoteItemExpenseFactory
	{
		return QuoteItemExpenseFactory::new();
	}
}
