<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Locations;

use Database\Factories\Locations\LiquorAuthorityFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models

//Enums

//Traits
use App\Traits\Locations\BelongsToProvince;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Contacts\ManyAddressable;
use App\Traits\Users\Notable;
use App\Traits\Users\Officialable;
use App\Traits\Users\Uploadable;

/**
 * Class LiquorAuthority
 * 
 * @property int $liquor_authority_id
 * @property int $province_id
 * @property int|null $parent_id
 * @property string $liquor_authority_name
 * 
 * @property LiquorAuthority|null $parent
 * @property Collection|LiquorAuthority[] $children
 *
 * @package App\Models
 */
class LiquorAuthority extends Model
{
	use BelongsToProvince;
	use Officialable;
	use ManyAddressable;
	use Uploadable;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const LIQUOR_AUTHORITY_ID 		= 'liquor_authority_id';
	const PROVINCE_ID 				= 'province_id';
	const PARENT_ID 				= 'parent_id';
	const LIQUOR_AUTHORITY_NAME		= 'liquor_authority_name';
	const TABLE_NAME 				= 'liquor_authorities';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::LIQUOR_AUTHORITY_ID;
	public $timestamps 				= false;
	public $incrementing 			= true;

	protected $casts = [
		self::LIQUOR_AUTHORITY_ID	=> 'int',
		self::PROVINCE_ID 			=> 'int',
		self::PARENT_ID 			=> 'int'
	];

	protected $fillable = [
		self::PROVINCE_ID,
		self::PARENT_ID,
		self::LIQUOR_AUTHORITY_NAME
	];

	protected static array $lowercase = [
		self::LIQUOR_AUTHORITY_NAME	
	];

	/**
	 * NOTE: Need to convert these children and parent relationships into the ones used by the heirarchy package
	 */

	/**
	 * Returns the parent this liquor authoirty belongs to 
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function parent(): BelongsTo
	{
		return $this->belongsTo(LiquorAuthority::class, LiquorAuthority::PARENT_ID);
	}

	/**
	 * Returns the children this liquor auhtoirty has
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function children(): HasMany
	{
		return $this->hasMany(LiquorAuthority::class, LiquorAuthority::PARENT_ID);
	}

	public static function factory(): LiquorAuthorityFactory
	{
		return LiquorAuthorityFactory::new();
	}
}
