<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Locations;

use Database\Factories\Locations\DistrictFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Locations\Municipality;

//Enums

//Traits
use App\Traits\Locations\BelongsToProvince;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class District
 * 
 * @property int $district_id
 * @property int $province_id
 * @property string $district_name
 * 
 * @property Collection|Municipality[] $municipalities
 *
 * @package App\Models
 */
class District extends Model
{
	use BelongsToProvince;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const DISTRICT_ID 		= 'district_id';
	const PROVINCE_ID 		= 'province_id';
	const DISTRICT_NAME 	= 'district_name';
	const DISTRICT_CODE 	= 'district_code';
	const TABLE_NAME 		= 'districts';
	protected $table 		= self::TABLE_NAME;
	protected $primaryKey 	= self::DISTRICT_ID;
	public $timestamps 		= false;
	public $incrementing 	= true;

	protected $casts = [
		self::DISTRICT_ID 	=> 'int',
		self::PROVINCE_ID 	=> 'int'
	];

	protected $fillable = [
		self::PROVINCE_ID,
		self::DISTRICT_NAME,
		self::DISTRICT_CODE
	];

	protected static array $lowercase = [
		self::DISTRICT_NAME,
		self::DISTRICT_CODE,
	];

	/**
	 * Returns the municipalities this district has
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function municipalities(): HasMany
	{
		return $this->hasMany(Municipality::class, self::DISTRICT_ID);
	}

	public static function factory(): DistrictFactory
	{
		return DistrictFactory::new();
	}
}
