<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Locations;

use Database\Factories\Locations\DepartmentTypeFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Locations\Department;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class DepartmentType
 * 
 * @property int $department_type_id
 * @property string $department_type
 * 
 * @property Collection|Department[] $departments
 *
 * @package App\Models
 */
class DepartmentType extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const DEPARTMENT_TYPE_ID 		= 'department_type_id';
	const DEPARTMENT_TYPE 			= 'department_type';
	const TABLE_NAME 				= 'department_types';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::DEPARTMENT_TYPE_ID;
	public $incrementing 			= true;
	public $timestamps 				= false;

	protected $casts = [
		self::DEPARTMENT_TYPE_ID 	=> 'int',
	];

	protected $fillable = [
		self::DEPARTMENT_TYPE
	];

	protected static array $lowercase = [
		self::DEPARTMENT_TYPE,	
	];

	/**
	 * Return the departments of this type
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function departments(): HasMany
	{
		return $this->hasMany(Department::class, self::DEPARTMENT_TYPE_ID);
	}

	public static function factory(): DepartmentTypeFactory
	{
		return DepartmentTypeFactory::new();
	}
}
