<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Locations;

use Database\Factories\Locations\DepartmentFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Locations\DepartmentType;

//Enums

//Traits
use App\Traits\Locations\BelongsToFranchise;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Contacts\ManyAddressable;
use App\Traits\Users\Notable;
use App\Traits\Users\Officialable;
use App\Traits\Users\Uploadable;

/**
 * Class Department
 * 
 * @property int $department_id
 * @property int $franchise_id
 * @property int|null $department_type_id
 * @property string $department_name
 * 
 * @property DepartmentType|null $departmentType
 *
 * @package App\Models
 */
class Department extends Model
{
	use Officialable;
	use ManyAddressable;
	use Uploadable;
	use Notable;
	use HasFactory;
	use BelongsToFranchise;
	use LowercaseAttributes;

	const DEPARTMENT_ID 			= 'department_id';
	const FRANCHISE_ID 				= 'franchise_id';
	const DEPARTMENT_TYPE_ID 		= 'department_type_id';
	const DEPARTMENT_NAME 			= 'department_name';
	const TABLE_NAME 				= 'departments';
	protected $table 				= self::TABLE_NAME;
	public $incrementing 			= true;
	protected $primaryKey 			= self::DEPARTMENT_ID;
	public $timestamps 				= false;

	protected $casts = [
		self::DEPARTMENT_ID 		=> 'int',
		self::FRANCHISE_ID 			=> 'int',
		self::DEPARTMENT_TYPE_ID 	=> 'int'
	];

	protected $fillable = [
		self::FRANCHISE_ID,
		self::DEPARTMENT_TYPE_ID,
		self::DEPARTMENT_NAME
	];

	protected static array $lowercase = [
		self::DEPARTMENT_NAME,	
	];

	/**
	 * Returns the department type this department belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function departmentType(): BelongsTo
	{
		return $this->belongsTo(DepartmentType::class, DepartmentType::DEPARTMENT_TYPE_ID);
	}

	public static function factory(): DepartmentFactory
	{
		return DepartmentFactory::new();
	}
}
