<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\StepFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

//Models
use App\Models\Items\Item;
use App\Models\Items\ItemStep;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Step
 * 
 * @property int $step_id
 * @property string $step_name
 * @property string $step_message
 * 
 * @property Collection|Item[] $items
 *
 * @package App\Models
 */
class Step extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const STEP_ID 			= 'step_id';
	const STEP_NAME 		= 'step_name';
	const STEP_MESSAGE 		= 'step_message';
	const TABLE_NAME 		= 'steps';
	protected $table 		= self::TABLE_NAME;
	protected $primaryKey 	= self::STEP_ID;
	public $timestamps 		= false;
	public $incrementing 	= true;

	protected $casts = [
		self::STEP_ID 		=> 'int'
	];

	protected $fillable = [
		self::STEP_NAME,
		self::STEP_MESSAGE
	];

	protected static array $lowercase = [
		self::STEP_NAME,
		self::STEP_MESSAGE,	
	];

	/**
	 * Returns the items that are currently on this step
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
	 */
	public function items(): BelongsToMany
	{
		return $this->belongsToMany(Item::class, 
									ItemStep::TABLE_NAME, 
									self::STEP_ID, 
									Item::ITEM_ID)
					->withPivot(ItemStep::ITEM_STEP_ID, ItemStep::ITEM_ID, ItemStep::STEP_ID);
	}

	public static function factory(): StepFactory
	{
		return StepFactory::new();
	}
}
