<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\ProvinceItemFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums

//Traits
use App\Traits\Items\BelongsToItem;
use App\Traits\Locations\BelongsToProvince;
use App\Traits\Users\Notable;

/**
 * Class ProvinceItem
 * 
 * @property int $province_item_id
 * @property int $item_id
 * @property int $province_id
 *
 * @package App\Models
 */
class ProvinceItem extends Model
{
	use BelongsToItem;
	use BelongsToProvince;
	use Notable;
	use HasFactory;

	const PROVINCE_ITEM_ID 		= 'province_item_id';
	const ITEM_ID 				= 'item_id';
	const PROVINCE_ID 			= 'province_id';
	const TABLE_NAME 			= 'province_items';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::PROVINCE_ITEM_ID;
	public $incrementing 		= true;
	public $timestamps 			= false;

	protected $casts = [
		self::PROVINCE_ITEM_ID 	=> 'int',
		self::ITEM_ID		 	=> 'int',
		self::PROVINCE_ID 		=> 'int'
	];

	protected $fillable = [
		self::ITEM_ID,
		self::PROVINCE_ID
	];

	public static function factory(): ProvinceItemFactory
	{
		return ProvinceItemFactory::new();
	}
}
