<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\ItemStepFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Items\Step;
use App\Models\Items\BusinessItem;

//Enums

//Traits
use App\Traits\Items\BelongsToItem;
use App\Traits\Users\Notable;

/**
 * Class ItemStep
 * 
 * @property int $item_step_id
 * @property int $step_id
 * @property int $item_id
 * 
 * @property Step $step
 * @property Collection|BusinessItem[] $businessItem
 *
 * @package App\Models
 */
class ItemStep extends Model
{
	use BelongsToItem;
	use Notable;
	use HasFactory;
	
	const ITEM_STEP_ID 		= 'item_step_id';
	const STEP_ID 			= 'step_id';
	const ITEM_ID 			= 'item_id';
	const TABLE_NAME 		= 'item_steps';
	protected $table 		= self::TABLE_NAME;
	public $incrementing 	= true;
	protected $primaryKey 	= self::ITEM_STEP_ID;
	public $timestamps 		= false;

	protected $casts = [
		self::ITEM_STEP_ID 	=> 'int',
		self::STEP_ID 		=> 'int',
		self::ITEM_ID 		=> 'int'
	];

	protected $fillable = [
		self::STEP_ID,
		self::ITEM_ID
	];

	/**
	 * Returns the step for this item step
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function step(): BelongsTo
	{
		return $this->belongsTo(Step::class, Step::STEP_ID);
	}

	/**
	 * Returns the business item that is on this step
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function businessItem(): HasMany
	{
		return $this->hasMany(BusinessItem::class, ItemStep::ITEM_STEP_ID);
	}

	public static function factory(): ItemStepFactory
	{
		return ItemStepFactory::new();
	}
}
