<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\ItemExpenseFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models

//Enums

//Traits
use App\Traits\Items\BelongsToItem;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;
use App\Traits\Users\Uploadable;

/**
 * Class ItemExpense
 * 
 * @property int $item_expense_id
 * @property int $item_id
 * @property string $item_expense_name
 * @property string $item_expense_description
 * @property float $item_expense_price
 *
 * @package App\Models
 */
class ItemExpense extends Model
{
	use BelongsToItem;
	use Uploadable;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const ITEM_EXPENSE_ID 			= 'item_expense_id';
	const ITEM_ID 					= 'item_id';
	const ITEM_EXPENSE_NAME 		= 'item_expense_name';
	const ITEM_EXPENSE_DESCRIPTION 	= 'item_expense_description';
	const ITEM_EXPENSE_PRICE 		= 'item_expense_price';
	const TABLE_NAME 				= 'item_expenses';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::ITEM_EXPENSE_ID;
	public $timestamps 				= false;
	public $incrementing	 		= true;

	protected $casts = [
		self::ITEM_EXPENSE_ID 		=> 'int',
		self::ITEM_ID 				=> 'int',
		self::ITEM_EXPENSE_PRICE 	=> 'float'
	];

	protected $fillable = [
		self::ITEM_ID,
		self::ITEM_EXPENSE_NAME,
		self::ITEM_EXPENSE_DESCRIPTION,
		self::ITEM_EXPENSE_PRICE
	];

	protected static array $lowercase = [
		self::ITEM_EXPENSE_NAME,
		self::ITEM_EXPENSE_DESCRIPTION,	
	];

	public static function factory(): ItemExpenseFactory
	{
		return ItemExpenseFactory::new();
	}
}
