<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\CategoryFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Items\Item;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Category
 * 
 * @property int $category_id
 * @property int|null $parent_id
 * @property string $category_name
 * @property string|null $category_description
 * 
 * @property Category|null $parent
 * @property Collection|Category[] $children
 * @property Collection|Item[] $items
 *
 * @package App\Models
 */
class Category extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const CATEGORY_ID 			= 'category_id';
	const PARENT_ID 			= 'parent_id';
	const CATEGORY_NAME 		= 'category_name';
	const CATEGORY_DESCRIPTION 	= 'category_description';
	const TABLE_NAME 			= 'categories';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::CATEGORY_ID;
	public $incrementing 		= true;
	public $timestamps 			= false;

	protected $casts = [
		self::CATEGORY_ID 		=> 'int',
		self::PARENT_ID 		=> 'int'
	];

	protected $fillable = [
		self::PARENT_ID,
		self::CATEGORY_NAME,
		self::CATEGORY_DESCRIPTION
	];

	protected static array $lowercase = [
		self::CATEGORY_NAME,
		self::CATEGORY_DESCRIPTION,	
	];

	#TODO
	/**
	 * MAKE USE OF CHILDREN AND PARENT RELATIONSHIP FROM PACKAGE
	 */
	#TODO

	/**
	 * Returns the parent that this category belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function parent(): BelongsTo
	{
		return $this->belongsTo(Category::class, Category::PARENT_ID);
	}

	/**
	 * returns the children categories that have this category as their parent
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function children(): HasMany
	{
		return $this->hasMany(Category::class, self::PARENT_ID);
	}

	/**
	 * Returns all the items of this category
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function items(): HasMany
	{
		return $this->hasMany(Item::class, self::CATEGORY_ID);
	}

	public static function factory(): CategoryFactory
	{
		return CategoryFactory::new();
	}
}
