<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Items;

use Database\Factories\Items\BusinessItemExtraFieldFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Items\BusinessItem;

//Enums
use App\Enums\Items\BusinessExtraItemFieldName;

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class BusinessItemExtraField
 * 
 * @property int $business_item_extra_field_id
 * @property int $business_item_id
 * @property BusinessExtraItemFieldName::class $extra_field_name
 * @property string $extra_field_value
 * 
 * @property BusinessItem $businessItem
 *
 * @package App\Models
 */
class BusinessItemExtraField extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const BUSINESS_ITEM_EXTRA_FIELD_ID 		= 'business_item_extra_field_id';
	const BUSINESS_ITEM_ID 					= 'business_item_id';
	const EXTRA_FIELD_NAME 					= 'extra_field_name';
	const EXTRA_FIELD_VALUE 				= 'extra_field_value';
	const TABLE_NAME 						= 'business_item_extra_fields';
	protected $table 						= self::TABLE_NAME;
	protected $primaryKey 					= self::BUSINESS_ITEM_EXTRA_FIELD_ID;
	public $incrementing 					= true;
	public $timestamps 						= false;

	protected $casts = [
		self::BUSINESS_ITEM_EXTRA_FIELD_ID 	=> 'int',
		self::BUSINESS_ITEM_ID 				=> 'int',
		self::EXTRA_FIELD_NAME 				=> BusinessExtraItemFieldName::class
	];

	protected $fillable = [
		self::BUSINESS_ITEM_ID,
		self::EXTRA_FIELD_NAME,
		self::EXTRA_FIELD_VALUE
	];

	protected static array $lowercase = [
		self::EXTRA_FIELD_NAME,
		self::EXTRA_FIELD_VALUE	
	];

	/**
	 * Returns the business item that this extra field belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function businessItem(): BelongsTo
	{
		return $this->belongsTo(BusinessItem::class, BusinessItem::BUSINESS_ITEM_ID);
	}

	public static function factory(): BusinessItemExtraFieldFactory
	{
		return BusinessItemExtraFieldFactory::new();
	}
}
