<?php

namespace App\Models\Invoices;

use Database\Factories\Invoices\InvoiceTermsFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models
use App\Models\Invoices\Invoice;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class InvoiceTerms
 * 
 * @property int $invoice_terms_id
 * @property string $invoice_terms_name
 * @property string $invoice_terms_description
 * @property string $invoice_terms_content
 * 
 * @property \Illuminate\Database\Eloquent\Collection|Invoice[] $invoices
 *
 * @package App\Models
 */
class InvoiceTerms extends Model
{
    use Notable;
    use HasFactory;
    use LowercaseAttributes;

    const INVOICE_TERMS_ID              = 'invoice_terms_id';
    const INVOICE_TERMS_NAME            = 'invoice_terms_name';
    const INVOICE_TERMS_DESCRIPTION     = 'invoice_terms_description';
    const INVOICE_TERMS_CONTENT         = 'invoice_terms_content';
    const TABLE_NAME                    = 'invoice_terms';
	protected $table                    = self::TABLE_NAME;
	protected $primaryKey               = self::INVOICE_TERMS_ID;
	public $timestamps                  = false;
	public $incrementing                = true;

	protected $casts = [
		self::INVOICE_TERMS_ID          => 'int',
	];

	protected $fillable = [
		self::INVOICE_TERMS_ID,
		self::INVOICE_TERMS_NAME,
		self::INVOICE_TERMS_DESCRIPTION,
		self::INVOICE_TERMS_CONTENT
	];

    protected static array $lowercase = [
        self::INVOICE_TERMS_DESCRIPTION,
        self::INVOICE_TERMS_NAME,
	];

    /**
     * Returns all the invoices that make use of this invoice terms
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function invoices() {
        return $this->hasMany(Invoice::class, self::INVOICE_TERMS_ID);
    }

    public static function factory(): InvoiceTermsFactory {
        return InvoiceTermsFactory::new();
    }
}
