<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Invoices;

use Database\Factories\Invoices\InvoiceItemExpenseFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Invoices\InvoiceItem;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class InvoiceItemExpense
 * 
 * @property int $invoice_item_expense_id
 * @property int $invoice_item_id
 * @property string $invoice_item_expense_name
 * @property string $invoice_item_expense_description
 * @property float $invoice_item_expense_price
 * 
 * @property InvoiceItem $invoiceItem
 *
 * @package App\Models
 */
class InvoiceItemExpense extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const INVOICE_ITEM_EXPENSE_ID 			= 'invoice_item_expense_id';
	const INVOICE_ITEM_ID 					= 'invoice_item_id';
	const INVOICE_ITEM_EXPENSE_NAME 		= 'invoice_item_expense_name';
	const INVOICE_ITEM_EXPENSE_DESCRIPTION 	= 'invoice_item_expense_description';
	const INVOICE_ITEM_EXPENSE_PRICE 		= 'invoice_item_expense_price';
	const TABLE_NAME 						= 'invoice_item_expenses';
	protected $table 						= self::TABLE_NAME;
	protected $primaryKey 					= self::INVOICE_ITEM_EXPENSE_ID;
	public $timestamps 						= false;
	public $incrementing 					= true;

	protected $casts = [
		self::INVOICE_ITEM_EXPENSE_ID 		=> 'int',
		self::INVOICE_ITEM_ID 				=> 'int',
		self::INVOICE_ITEM_EXPENSE_PRICE 	=> 'float'
	];

	protected $fillable = [
		self::INVOICE_ITEM_ID,
		self::INVOICE_ITEM_EXPENSE_NAME,
		self::INVOICE_ITEM_EXPENSE_DESCRIPTION,
		self::INVOICE_ITEM_EXPENSE_PRICE
	];

	protected static array $lowercase = [
		self::INVOICE_ITEM_EXPENSE_NAME,
		self::INVOICE_ITEM_EXPENSE_DESCRIPTION	
	];

	/**
	 * Returns the invoice item that this invoice item expense belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function invoiceItem(): BelongsTo
	{
		return $this->belongsTo(InvoiceItem::class, InvoiceItem::INVOICE_ITEM_ID);
	}

	public static function factory(): InvoiceItemExpenseFactory
	{
		return InvoiceItemExpenseFactory::new();
	}
}
