<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Database\Factories\Finances\PaymentMethodFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Finances\Payment;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class PaymentMethod
 * 
 * @property int $payment_method_id
 * @property string $payment_method_name
 * 
 * @property Collection|Payment[] $payments
 *
 * @package App\Models
 */
class PaymentMethod extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const PAYMENT_METHOD_ID 	= 'payment_method_id';
	const PAYMENT_METHOD_NAME 	= 'payment_method_name';
	const TABLE_NAME 			= 'payment_methods';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::PAYMENT_METHOD_ID;
	public $timestamps 			= false;
	public $incrementing 		= true;

	protected $casts = [
		self::PAYMENT_METHOD_ID	=> 'int'
	];

	protected $fillable = [
		self::PAYMENT_METHOD_NAME
	];

	protected static array $lowercase = [
		self::PAYMENT_METHOD_NAME,
	];

	/**
	 * Returns the payments that have used this method
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function payments(): HasMany
	{
		return $this->hasMany(Payment::class, self::PAYMENT_METHOD_ID);
	}
	
	public static function factory(): PaymentMethodFactory
	{
		return  PaymentMethodFactory::new();
	}
}
