<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Carbon\Carbon;
use Database\Factories\Finances\PaymentFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Finances\PaymentMethod;

//Enums
use App\Enums\Finances\PaymentType;

//Traits
use App\Traits\Users\Notable;

/**
 * Class Payment
 * 
 * @property int $payment_id
 * @property int $payment_method_id
 * @property PaymentType::class|null $payable_type
 * @property int|null $payable_id
 * @property Carbon $payment_date
 * @property float $payment_amount
 * 
 * @property PaymentMethod $paymentMethod
 *
 * @package App\Models
 */
class Payment extends Model
{
	use Notable;
	use HasFactory;
	
	const PAYMENT_ID 			= 'payment_id';
	const PAYMENT_METHOD_ID 	= 'payment_method_id';
	const PAYABLE_TYPE 			= 'payable_type';
	const PAYABLE_ID 			= 'payable_id';
	const PAYMENT_DATE 			= 'payment_date';
	const PAYMENT_AMOUNT 		= 'payment_amount';
	const TABLE_NAME 			= 'payments';
	const MORPH_NAME 			= 'payable';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::PAYMENT_ID;
	public $timestamps 			= false;
	public $incrementing 		= true;

	protected $casts = [
		self::PAYMENT_ID 		=> 'int',
		self::PAYMENT_METHOD_ID => 'int',
		self::PAYABLE_TYPE 		=> PaymentType::class,
		self::PAYABLE_ID 		=> 'int',
		self::PAYMENT_DATE 		=> 'datetime',
		self::PAYMENT_AMOUNT 	=> 'float'
	];

	protected $fillable = [
		self::PAYMENT_METHOD_ID,
		self::PAYABLE_TYPE,
		self::PAYABLE_ID,
		self::PAYMENT_DATE,
		self::PAYMENT_AMOUNT
	];

	/**
	 * Returns the payment method used by this payment
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function paymentMethod(): BelongsTo
	{
		return $this->belongsTo(PaymentMethod::class, PaymentMethod::PAYMENT_METHOD_ID);
	}

	public static function factory(): PaymentFactory
	{
		return PaymentFactory::new();
	}
}
