<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Database\Factories\Finances\ExpenseCategoryFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Finances\ExpenseBankCategory;
use App\Models\Finances\Expense;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class ExpenseCategory
 * 
 * @property int $expense_category_id
 * @property int|null $expense_bank_category_id
 * @property string $expense_category_number
 * @property string $expense_category_name
 * 
 * @property ExpenseBankCategory|null $expenseBankCategory
 * @property Collection|Expense[] $expenses
 *
 * @package App\Models
 */
class ExpenseCategory extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const EXPENSE_CATEGORY_ID 			= 'expense_category_id';
	const EXPENSE_BANK_CATEGORY_ID 		= 'expense_bank_category_id';
	const EXPENSE_CATEGORY_NUMBER 		= 'expense_category_number';
	const EXPENSE_CATEGORY_NAME 		= 'expense_category_name';
	const TABLE_NAME 					= 'expense_categories';
	protected $table 					= self::TABLE_NAME;
	protected $primaryKey 				= self::EXPENSE_CATEGORY_ID;
	public $timestamps 					= false;
	public $incrementing 				= true;

	protected $casts = [
		self::EXPENSE_CATEGORY_ID 		=> 'int',
		self::EXPENSE_BANK_CATEGORY_ID 	=> 'int'
	];

	protected $fillable = [
		self::EXPENSE_BANK_CATEGORY_ID,
		self::EXPENSE_CATEGORY_NUMBER,
		self::EXPENSE_CATEGORY_NAME
	];

	protected static array $lowercase = [
		self::EXPENSE_CATEGORY_NAME	
	];

	/**
	 * Returns the bank category this expense category belongs to
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function expenseBankCategory(): BelongsTo
	{
		return $this->belongsTo(ExpenseBankCategory::class, ExpenseBankCategory::EXPENSE_BANK_CATEGORY_ID);
	}

	/**
	 * Returns the expenses of this expense category
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function expenses(): HasMany
	{
		return $this->hasMany(Expense::class, self::EXPENSE_CATEGORY_ID);
	}

	public static function factory(): ExpenseCategoryFactory
	{
		return ExpenseCategoryFactory::new();
	}
}
