<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Database\Factories\Finances\ExpenseBankCategoryFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Finances\ExpenseCategory;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class ExpenseBankCategory
 * 
 * @property int $expense_bank_category_id
 * @property string $expense_category_name
 * 
 * @property Collection|ExpenseCategory[] $expenseCategories
 *
 * @package App\Models
 */
class ExpenseBankCategory extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const EXPENSE_BANK_CATEGORY_ID 		= 'expense_bank_category_id';
	const EXPENSE_CATEGORY_NAME 		= 'expense_category_name';
	const TABLE_NAME 					= 'expense_bank_categories';
	protected $table 					= self::TABLE_NAME;
	protected $primaryKey 				= self::EXPENSE_BANK_CATEGORY_ID;
	public $incrementing 				= true;
	public $timestamps 					= false;

	protected $casts = [
		self::EXPENSE_BANK_CATEGORY_ID 	=> 'int'
	];

	protected $fillable = [
		self::EXPENSE_CATEGORY_NAME
	];

	protected static array $lowercase = [
		self::EXPENSE_CATEGORY_NAME
	];

	/**
	 * Return the expense categries this bank category has
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function expenseCategories(): HasMany
	{
		return $this->hasMany(ExpenseCategory::class, self::EXPENSE_BANK_CATEGORY_ID);
	}

	public static function factory(): ExpenseBankCategoryFactory
	{
		return ExpenseBankCategoryFactory::new();
	}
}
