<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Database\Factories\Finances\CreditorFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Finances\Expense;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Creditor
 * 
 * @property int $creditor_id
 * @property string $creditor_name
 * @property string $creditor_description
 * 
 * @property Collection|Expense[] $expenses
 *
 * @package App\Models
 */
class Creditor extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const CREDITOR_ID 			= 'creditor_id';
	const CREDITOR_NAME 		= 'creditor_name';
	const CREDITOR_DESCRIPTION 	= 'creditor_description';
	const TABLE_NAME 			= 'creditors';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::CREDITOR_ID;
	public $timestamps 			= false;
	public $incrementing 		= true;

	protected $casts = [
		self::CREDITOR_ID 		=> 'int'
	];

	protected $fillable = [
		self::CREDITOR_NAME,
		self::CREDITOR_DESCRIPTION
	];

	protected static array $lowercase = [
		self::CREDITOR_NAME,
		self::CREDITOR_DESCRIPTION,	
	];

	/**
	 * Returns the expenses this creditor has
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function expenses(): HasMany
	{
		return $this->hasMany(Expense::class, self::CREDITOR_ID);
	}

	public static function factory(): CreditorFactory
	{
		return CreditorFactory::new();
	}
}
