<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Finances;

use Database\Factories\Finances\BankFactory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

//Models
use App\Models\Finances\BankAccount;

//Enums

//Traits
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Bank
 * 
 * @property int $bank_id
 * @property string $bank_name
 * 
 * @property Collection|BankAccount[] $bankAccounts
 *
 * @package App\Models
 */
class Bank extends Model
{
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const BANK_ID 			= 'bank_id';
	const BANK_NAME 		= 'bank_name';
	const TABLE_NAME 		= 'banks';
	protected $table 		= self::TABLE_NAME;
	protected $primaryKey 	= self::BANK_ID;
	public $incrementing 	= true;
	public $timestamps 		= false;

	protected $casts = [
		self::BANK_ID 		=> 'int'
	];

	protected $fillable = [
		self::BANK_NAME
	];

	protected static array $lowercase = [
		self::BANK_NAME	
	];

	/**
	 * Returns the bank accounts associated with this bank
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function bankAccounts(): HasMany
	{
		return $this->hasMany(BankAccount::class, self::BANK_ID);
	}

	public static function factory(): BankFactory
	{
		return BankFactory::new();
	}
}
