<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Contacts;

use Carbon\Carbon;
use Database\Factories\Contacts\ProspectFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Quotes\Quote;

//Enums
use App\Enums\Users\ProspectStatus;
use App\Enums\Locations\ProvinceType;

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Prospect
 * 
 * @property int $prospects_id
 * @property int|null $user_id
 * @property int|null $quote_id
 * @property string $prospects_first_name
 * @property string|null $prospects_last_name
 * @property string $prospects_business_name
 * @property ProspectStatus::class $prospects_status
 * @property string|null $prospects_number
 * @property string|null $prospects_whatsapp
 * @property string|null $prospects_email
 * @property string|null $prospects_street_address
 * @property string|null $prospects_suburb
 * @property string|null $prospects_city
 * @property string|null $prospects_province
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Quote|null $quote
 *
 * @package App\Models
 */
class Prospect extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const PROSPECTS_ID 				= 'prospects_id';
	const USER_ID 					= 'user_id';
	const QUOTE_ID 					= 'quote_id';
	const PROSPECTS_FIRST_NAME 		= 'prospects_first_name';
	const PROSPECTS_LAST_NAME 		= 'prospects_last_name';
	const PROSPECTS_BUSINESS_NAME 	= 'prospects_business_name';
	const PROSPECTS_STATUS 			= 'prospects_status';
	const PROSPECTS_NUMBER 			= 'prospects_number';
	const PROSPECTS_WHATSAPP 		= 'prospects_whatsapp';
	const PROSPECTS_EMAIL 			= 'prospects_email';
	const PROSPECTS_STREET_ADDRESS 	= 'prospects_street_address';
	const PROSPECTS_SUBURB 			= 'prospects_suburb';
	const PROSPECTS_CITY 			= 'prospects_city';
	const PROSPECTS_PROVINCE 		= 'prospects_province';
	const CREATED_AT 				= 'created_at';
	const UPDATED_AT 				= 'updated_at';
	const TABLE_NAME 				= 'prospects';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::PROSPECTS_ID;
	public $incrementing 			= true;

	protected $casts = [
		self::PROSPECTS_ID 			=> 'int',
		self::USER_ID 				=> 'int',
		self::QUOTE_ID 				=> 'int',
		self::PROSPECTS_STATUS 		=> ProspectStatus::class,
		self::PROSPECTS_PROVINCE	=> ProvinceType::class,
		self::CREATED_AT 			=> 'datetime',
		self::UPDATED_AT 			=> 'datetime'
	];

	protected $fillable = [
		self::USER_ID,
		self::QUOTE_ID,
		self::PROSPECTS_FIRST_NAME,
		self::PROSPECTS_LAST_NAME,
		self::PROSPECTS_BUSINESS_NAME,
		self::PROSPECTS_STATUS,
		self::PROSPECTS_NUMBER,
		self::PROSPECTS_WHATSAPP,
		self::PROSPECTS_EMAIL,
		self::PROSPECTS_STREET_ADDRESS,
		self::PROSPECTS_SUBURB,
		self::PROSPECTS_CITY,
		self::PROSPECTS_PROVINCE
	];

	protected static array $lowercase = [
		self::PROSPECTS_FIRST_NAME,
		self::PROSPECTS_LAST_NAME,
		self::PROSPECTS_BUSINESS_NAME,
		self::PROSPECTS_EMAIL,
		self::PROSPECTS_STREET_ADDRESS,
		self::PROSPECTS_SUBURB,
		self::PROSPECTS_CITY,
	];

	/**
	 * Return the quote that this prospect has
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function quote(): BelongsTo
	{
		return $this->belongsTo(Quote::class,  Quote::QUOTE_ID);
	}

	public static function factory(): ProspectFactory
	{
		return ProspectFactory::new();
	}
}
