<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Contacts;

use Carbon\Carbon;
use Database\Factories\Contacts\LeadFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models

//Enums

//Traits
use App\Traits\Users\BelongsToUser;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class Lead
 * 
 * @property int $lead_id
 * @property int|null $user_id
 * @property string $lead_first_name
 * @property string $lead_last_name
 * @property string $lead_email
 * @property string $lead_number
 * @property string $lead_town_city
 * @property string $lead_province
 * @property string $lead_enquiries
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Lead extends Model
{
	use BelongsToUser;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const LEAD_ID 				= 'lead_id';
	const USER_ID 				= 'user_id';
	const LEAD_FIRST_NAME 		= 'lead_first_name';
	const LEAD_LAST_NAME 		= 'lead_last_name';
	const LEAD_EMAIL 			= 'lead_email';
	const LEAD_NUMBER 			= 'lead_number';
	const LEAD_TOWN_CITY 		= 'lead_town_city';
	const LEAD_PROVINCE 		= 'lead_province';
	const LEAD_ENQUIRIES 		= 'lead_enquiries';
	const CREATED_AT 			= 'created_at';
	const UPDATED_AT 			= 'updated_at';
	const TABLE_NAME 			= 'leads';
	protected $table 			= self::TABLE_NAME;
	protected $primaryKey 		= self::LEAD_ID;
	public $incrementing 		= true;

	protected $casts = [
		self::LEAD_ID 			=> 'int',
		self::USER_ID 			=> 'int',
		self::CREATED_AT 		=> 'datetime',
		self::UPDATED_AT 		=> 'datetime'
	];

	protected $fillable = [
		self::USER_ID,
		self::LEAD_FIRST_NAME,
		self::LEAD_LAST_NAME,
		self::LEAD_EMAIL,
		self::LEAD_NUMBER,
		self::LEAD_TOWN_CITY,
		self::LEAD_PROVINCE,
		self::LEAD_ENQUIRIES
	];

	protected static array $lowercase = [
		self::LEAD_FIRST_NAME,
		self::LEAD_LAST_NAME,
		self::LEAD_EMAIL,
		self::LEAD_PROVINCE,
		self::LEAD_ENQUIRIES,
		self::LEAD_TOWN_CITY	
	];

	public static function factory(): LeadFactory
	{
		return LeadFactory::new();
	}
}
