<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Contacts;

use App\Observers\Contacts\ContactMethodObserver;
use Database\Factories\Contacts\ContactMethodFactory;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models

//Enums
use App\Enums\Contacts\ContactMethodType;

//Traits
use App\Traits\Contacts\BelongsToContact;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class ContactMethod
 * 
 * @property int $contact_method_id
 * @property int $contact_id
 * @property ContactMethodType::class $contact_method_type
 * @property string $contact_method_info
 * @property bool $is_primary
 *
 * @package App\Models
 */

#[ObservedBy(ContactMethodObserver::class)]
class ContactMethod extends Model
{
	use BelongsToContact;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;
	
	const CONTACT_METHOD_ID 		= 'contact_method_id';
	const CONTACT_ID 				= 'contact_id';
	const CONTACT_METHOD_TYPE 		= 'contact_method_type';
	const CONTACT_METHOD_INFO 		= 'contact_method_info';
	const IS_PRIMARY 				= 'is_primary';
	const TABLE_NAME 				= 'contact_methods';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::CONTACT_METHOD_ID;
	public $timestamps 				= false;
	public $incrementing 			= true;

	protected $casts = [
		self::CONTACT_METHOD_ID 	=> 'int',
		self::CONTACT_ID 			=> 'int',
		self::CONTACT_METHOD_TYPE 	=> ContactMethodType::class,
		self::IS_PRIMARY 			=> 'bool'
	];

	protected $fillable = [
		self::CONTACT_ID,
		self::CONTACT_METHOD_TYPE,
		self::CONTACT_METHOD_INFO,
		self::IS_PRIMARY
	];

	protected static array $lowercase = [
		self::CONTACT_METHOD_INFO	
	];

	protected $attributes = [
		self::IS_PRIMARY			=> false,
	];

	public static function factory(): ContactMethodFactory
	{
		return ContactMethodFactory::new();
	}
}
