<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Contacts;

use Database\Factories\Contacts\AddressExtraFieldFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

//Models
use App\Models\Contacts\Address;

//Enums
use App\Enums\Locations\AddressExtraFieldType;

//Traits
use App\Traits\Locations\BelongsToAddress;
use App\Traits\Core\LowercaseAttributes;
use App\Traits\Users\Notable;

/**
 * Class AddressExtraField
 * 
 * @property int $address_field_id
 * @property int $address_id
 * @property AddressExtraFieldType::class $address_field_name
 * @property string $address_field_value
 * 
 * @property Address $address
 *
 * @package App\Models
 */
class AddressExtraField extends Model
{
	use BelongsToAddress;
	use Notable;
	use HasFactory;
	use LowercaseAttributes;

	const ADDRESS_FIELD_ID 			= 'address_field_id';
	const ADDRESS_ID 				= 'address_id';
	const ADDRESS_FIELD_NAME 		= 'address_field_name';
	const ADDRESS_FIELD_VALUE 		= 'address_field_value';
	const TABLE_NAME 				= 'address_extra_fields';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::ADDRESS_FIELD_ID;
	public $incrementing 			= true;
	public $timestamps 				= false;

	protected $casts = [
		self::ADDRESS_FIELD_ID 		=> 'int',
		self::ADDRESS_ID 			=> 'int',
		self::ADDRESS_FIELD_NAME 	=> AddressExtraFieldType::class
	];

	protected $fillable = [
		self::ADDRESS_ID,
		self::ADDRESS_FIELD_NAME,
		self::ADDRESS_FIELD_VALUE
	];

	protected static array $lowercase = [
		self::ADDRESS_FIELD_NAME,
		self::ADDRESS_FIELD_VALUE,
	];

	public static function factory(): AddressExtraFieldFactory
	{
		return AddressExtraFieldFactory::new();
	}
}
