<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models\Businesses;

use App\Observers\Businesses\BusinessClientObserver;
use Database\Factories\Businesses\BusinessClientFactory;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

//Models
use App\Models\Users\Client;

//Enums
use App\Enums\Businesses\BusinessClientRole;

//Traits
use App\Traits\Businesses\BelongsToBusiness;
use App\Traits\Users\Notable;
use App\Traits\Users\Uploadable;

/**
 * Class BusinessClient
 * 
 * @property int $business_client_id
 * @property int $client_id
 * @property int $business_id
 * @property BusinessClientRole::class $client_role
 * @property bool $is_primary
 * 
 * @property Client $client
 *
 * @package App\Models
 */

#[ObservedBy(BusinessClientObserver::class)]
class BusinessClient extends Model
{
	use BelongsToBusiness;
	use Uploadable;
	use Notable;
	use HasFactory;

	const BUSINESS_CLIENT_ID		= 'business_client_id';
	const CLIENT_ID 				= 'client_id';
	const BUSINESS_ID 				= 'business_id';
	const CLIENT_ROLE 				= 'client_role';
	const IS_PRIMARY 				= 'is_primary';
	const TABLE_NAME 				= 'business_clients';
	protected $table 				= self::TABLE_NAME;
	protected $primaryKey 			= self::BUSINESS_CLIENT_ID;
	public $incrementing 			= true;
	public $timestamps 				= false;

	protected $casts = [
		self::BUSINESS_CLIENT_ID 	=> 'int',
		self::CLIENT_ID 			=> 'int',
		self::BUSINESS_ID 			=> 'int',
		self::CLIENT_ROLE 			=> BusinessClientRole::class,
		self::IS_PRIMARY 			=> 'bool'
	];

	protected $fillable = [
		self::CLIENT_ID,
		self::BUSINESS_ID,
		self::CLIENT_ROLE,
		self::IS_PRIMARY
	];

	protected $attributes = [
		self::IS_PRIMARY			=> false,
	];

	/**
	 * Returns ths client in this business client pivot record
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function client(): BelongsTo
	{
		return $this->belongsTo(Client::class, Client::CLIENT_ID);
	}

	public static function factory(): BusinessClientFactory
	{
		return BusinessClientFactory::new();
	}
}
