<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\UserResource\Pages;
use App\Filament\Resources\UserResource\RelationManagers;
use App\Models\Users\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('contact_id')->relationship('contact', 'name')->required(),
            Forms\Components\TextInput::make('bank_account_id'),
            Forms\Components\DatePicker::make('user_last_active_date'),
            Forms\Components\Toggle::make('user_can_access'),
            Forms\Components\TextInput::make('username'),
            Forms\Components\DatePicker::make('user_employment_date'),
            Forms\Components\TextInput::make('user_leave_days')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('contact.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('bank_account_id')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('user_last_active_date')->date()->toggleable(),
            Tables\Columns\IconColumn::make('user_can_access')->boolean()->toggleable(),
            Tables\Columns\TextColumn::make('username')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('user_employment_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('user_leave_days')->searchable()->sortable()->toggleable()
        ];
    }
}