<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\UserDisciplinaryResource\Pages;
use App\Filament\Resources\UserDisciplinaryResource\RelationManagers;
use App\Models\Users\UserDisciplinary;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UserDisciplinaryResource extends Resource
{
    protected static ?string $model = UserDisciplinary::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUserDisciplinaries::route('/'),
            'create' => Pages\CreateUserDisciplinary::route('/create'),
            'edit' => Pages\EditUserDisciplinary::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('disciplinary_id')->relationship('disciplinary', 'name')->required(),
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('disciplinary_status')->options(\App\Enums\DisciplinaryStatus::cases())->required(),
            Forms\Components\Select::make('disciplinary_action_taken')->options(\App\Enums\DisciplinaryAction::cases())->required(),
            Forms\Components\DatePicker::make('disciplinary_date_closed')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('disciplinary.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('disciplinary_status')->formatStateUsing(fn($state) => \App\Enums\DisciplinaryStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('disciplinary_action_taken')->formatStateUsing(fn($state) => \App\Enums\DisciplinaryAction::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('disciplinary_date_closed')->date()->toggleable()
        ];
    }
}