<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\UploadResource\Pages;
use App\Filament\Resources\UploadResource\RelationManagers;
use App\Models\Users\Upload;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UploadResource extends Resource
{
    protected static ?string $model = Upload::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUploads::route('/'),
            'create' => Pages\CreateUpload::route('/create'),
            'edit' => Pages\EditUpload::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('uploadable_type')->options(\App\Enums\UploadableType::cases())->required(),
            Forms\Components\Select::make('uploadable_id')->relationship('uploadable', 'name')->required(),
            Forms\Components\TextInput::make('file_type'),
            Forms\Components\TextInput::make('url_key'),
            Forms\Components\TextInput::make('file_description'),
            Forms\Components\TextInput::make('file_name_original'),
            Forms\Components\TextInput::make('file_name_new')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('uploadable_type')->formatStateUsing(fn($state) => \App\Enums\UploadableType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('uploadable.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('file_type')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('url_key')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('file_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('file_name_original')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('file_name_new')->searchable()->sortable()->toggleable()
        ];
    }
}