<?php

namespace App\Filament\Resources\UploadInformationResource\RelationManagers;

use App\Filament\Resources\UploadInformationResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UploadRelationManager extends RelationManager
{
    protected static string $relationship = 'upload';

    public function form(Form $form): Form
{
    return $form->schema(UploadInformationResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(UploadInformationResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
