<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\UploadInformationResource\Pages;
use App\Filament\Resources\UploadInformationResource\RelationManagers;
use App\Models\Users\UploadInformation;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UploadInformationResource extends Resource
{
    protected static ?string $model = UploadInformation::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUploadInformation::route('/'),
            'create' => Pages\CreateUploadInformation::route('/create'),
            'edit' => Pages\EditUploadInformation::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('upload_id')->relationship('upload', 'name')->required(),
            Forms\Components\TextInput::make('upload_value'),
            Forms\Components\Select::make('upload_value_type')->options(\App\Enums\UploadInformationValueType::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('upload.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('upload_value')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('upload_value_type')->formatStateUsing(fn($state) => \App\Enums\UploadInformationValueType::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}