<?php

namespace App\Filament\Resources\TemporaryAccessResource\RelationManagers;

use App\Filament\Resources\TemporaryAccessResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OfficialRelationManager extends RelationManager
{
    protected static string $relationship = 'official';

    public function form(Form $form): Form
{
    return $form->schema(TemporaryAccessResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(TemporaryAccessResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
