<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\TemporaryAccessResource\Pages;
use App\Filament\Resources\TemporaryAccessResource\RelationManagers;
use App\Models\Users\TemporaryAccess;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class TemporaryAccessResource extends Resource
{
    protected static ?string $model = TemporaryAccess::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTemporaryAccesses::route('/'),
            'create' => Pages\CreateTemporaryAccess::route('/create'),
            'edit' => Pages\EditTemporaryAccess::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('accessible_type')->options(\App\Enums\TemporaryAccessType::cases())->required(),
            Forms\Components\Select::make('accessible_id')->relationship('accessible', 'name')->required(),
            Forms\Components\TextInput::make('temporary_password_hashed'),
            Forms\Components\Toggle::make('was_accessed'),
            Forms\Components\DatePicker::make('temporary_access_start_time'),
            Forms\Components\DatePicker::make('temporary_access_end_time')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('accessible_type')->formatStateUsing(fn($state) => \App\Enums\TemporaryAccessType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('accessible.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('temporary_password_hashed')->searchable()->sortable()->toggleable(),
            Tables\Columns\IconColumn::make('was_accessed')->boolean()->toggleable(),
            Tables\Columns\TextColumn::make('temporary_access_start_time')->date()->toggleable(),
            Tables\Columns\TextColumn::make('temporary_access_end_time')->date()->toggleable()
        ];
    }
}