<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\QuoteResource\Pages;
use App\Filament\Resources\QuoteResource\RelationManagers;
use App\Models\Quotes\Quote;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class QuoteResource extends Resource
{
    protected static ?string $model = Quote::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListQuotes::route('/'),
            'create' => Pages\CreateQuote::route('/create'),
            'edit' => Pages\EditQuote::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('business_id')->relationship('business', 'name')->required(),
            Forms\Components\Select::make('franchise_id')->relationship('franchise', 'name')->required(),
            Forms\Components\TextInput::make('quote_number'),
            Forms\Components\Select::make('quote_status')->options(\App\Enums\QuoteStatus::cases())->required(),
            Forms\Components\TextInput::make('quote_url_key'),
            Forms\Components\TextInput::make('quote_item_discount_total'),
            Forms\Components\TextInput::make('quote_item_tax_total'),
            Forms\Components\TextInput::make('quote_item_subtotal'),
            Forms\Components\TextInput::make('quote_total'),
            Forms\Components\DatePicker::make('quote_date_expires')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('franchise.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_status')->formatStateUsing(fn($state) => \App\Enums\QuoteStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_url_key')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_discount_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_tax_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_subtotal')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_date_expires')->date()->toggleable()
        ];
    }
}