<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\QuoteItemResource\Pages;
use App\Filament\Resources\QuoteItemResource\RelationManagers;
use App\Models\Quotes\QuoteItem;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class QuoteItemResource extends Resource
{
    protected static ?string $model = QuoteItem::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListQuoteItems::route('/'),
            'create' => Pages\CreateQuoteItem::route('/create'),
            'edit' => Pages\EditQuoteItem::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('quote_id')->relationship('quote', 'name')->required(),
            Forms\Components\Select::make('item_id')->relationship('item', 'name')->required(),
            Forms\Components\Select::make('province_service_id')->relationship('provinceService', 'name')->required(),
            Forms\Components\DatePicker::make('item_date_added'),
            Forms\Components\TextInput::make('item_name'),
            Forms\Components\TextInput::make('item_description'),
            Forms\Components\TextInput::make('item_quantity'),
            Forms\Components\TextInput::make('item_professional_fee'),
            Forms\Components\TextInput::make('item_miscellaneous_fee'),
            Forms\Components\TextInput::make('item_price'),
            Forms\Components\TextInput::make('item_discount'),
            Forms\Components\TextInput::make('item_tax_total'),
            Forms\Components\TextInput::make('item_subtotal'),
            Forms\Components\TextInput::make('item_expense_total'),
            Forms\Components\TextInput::make('item_total')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('quote.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('provinceService.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_date_added')->date()->toggleable(),
            Tables\Columns\TextColumn::make('item_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_quantity')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_professional_fee')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_miscellaneous_fee')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_price')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_discount')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_tax_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_subtotal')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_expense_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_total')->searchable()->sortable()->toggleable()
        ];
    }
}