<?php

namespace App\Filament\Resources\QuoteItemExpenseResource\RelationManagers;

use App\Filament\Resources\QuoteItemExpenseResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class QuoteItemRelationManager extends RelationManager
{
    protected static string $relationship = 'quoteItem';

    public function form(Form $form): Form
{
    return $form->schema(QuoteItemExpenseResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(QuoteItemExpenseResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
