<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\QuoteItemExpenseResource\Pages;
use App\Filament\Resources\QuoteItemExpenseResource\RelationManagers;
use App\Models\Quotes\QuoteItemExpense;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class QuoteItemExpenseResource extends Resource
{
    protected static ?string $model = QuoteItemExpense::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListQuoteItemExpenses::route('/'),
            'create' => Pages\CreateQuoteItemExpense::route('/create'),
            'edit' => Pages\EditQuoteItemExpense::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('quote_item_id')->relationship('quoteItem', 'name')->required(),
            Forms\Components\TextInput::make('quote_item_expense_name'),
            Forms\Components\TextInput::make('quote_item_expense_description'),
            Forms\Components\TextInput::make('quote_item_expense_price')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('quoteItem.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_expense_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_expense_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote_item_expense_price')->searchable()->sortable()->toggleable()
        ];
    }
}